﻿/* Skripte zur Projektion von Zeilen
 * Auszufuehren als Benutzer SCOTT
 */
 
-- Einfache Projektion
select ename, job, sal
  from emp
 where job = 'MANAGER';
 
-- Projektion mit einem Spaltenvergleich
select empno, ename, job, mgr
  from emp
 where empno < mgr;
 
-- Projektionen können kein Spaltenalias benutzen
select ename, job, 12 * sal jahresgehalt
  from emp
 where 12 * sal > 50000;
 
-- Mitarbeiter aus Abteilung 30, die mehr als 1200 Taler verdienen
select ename, job, deptno, sal
  from emp
 where deptno = 30
   and sal > 1200;
   
-- komplexeres Beispiel mit Booleschen Operatoren
select ename, job, deptno, sal
  from emp
 where not(job = 'SALESMAN' or job = 'MANAGER')
   and (sal > 1500 or ename = 'SMITH');
   
-- Benutzung von LIKE
select ename, job, sal
  from emp
 where ename like 'M%';
 
-- Der Platzhalter _
select ename, job, sa
  from emp
 where ename like '_A%';
 
-- Maskierung des Platzhalterzeichens
select ename, job, sal
  from emp
 where job like 'C%/%' escape '/';

-- Beispiel für die Verwendung von REGEXP_LIKE
-- Suche nach Namen mit einem doppelten Buchstaben
select ename, job, sal
  from emp
 where regexp_like (ename, '([:alpha:])\1', 'i');
 
-- Verwendung von IN
select ename, job, sal
  from emp
 where job in ('SALESMAN', 'MANAGER');
 
-- Verwendung von BETWEEN
select grade
  from salgrade
 where 1750 between losal and hisal;
 
-- Schreibtischtest: Extremwert mit BETWEEN
select grade
  from salgrade
 where 3000 between losal and hisal;
 
-- Between mit Datumsangaben. ALs Benutzer HR ausfuehren!
select *
  from emp_history;